/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.schema.iso19139;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.fao.geonet.kernel.schema.AssociatedResource;
import org.fao.geonet.kernel.schema.AssociatedResourcesSchemaPlugin;
import org.fao.geonet.kernel.schema.ExportablePlugin;
import org.fao.geonet.kernel.schema.ISOPlugin;
import org.fao.geonet.kernel.schema.LinkAwareSchemaPlugin;
import org.fao.geonet.kernel.schema.LinkPatternStreamer.ILinkBuilder;
import org.fao.geonet.kernel.schema.LinkPatternStreamer.RawLinkPatternStreamer;
import org.fao.geonet.kernel.schema.MultilingualSchemaPlugin;
import org.fao.geonet.kernel.schema.SchemaPlugin;
import org.fao.geonet.schema.iso19139.ISO19139Namespaces;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.Namespace;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;
import org.jdom.xpath.XPath;

public class ISO19139SchemaPlugin
extends SchemaPlugin
implements AssociatedResourcesSchemaPlugin,
MultilingualSchemaPlugin,
ExportablePlugin,
ISOPlugin,
LinkAwareSchemaPlugin {
    public static final String IDENTIFIER = "iso19139";
    public static ImmutableSet<Namespace> allNamespaces = ImmutableSet.builder().add((Object)ISO19139Namespaces.GCO).add((Object)ISO19139Namespaces.GMD).add((Object)ISO19139Namespaces.SRV).build();
    private static Map<String, Namespace> allTypenames = ImmutableMap.builder().put((Object)"csw:Record", (Object)Namespace.getNamespace((String)"csw", (String)"http://www.opengis.net/cat/csw/2.0.2")).put((Object)"gmd:MD_Metadata", (Object)ISO19139Namespaces.GMD).put((Object)"dcat", (Object)Namespace.getNamespace((String)"dcat", (String)"http://www.w3.org/ns/dcat#")).build();
    private static Map<String, String> allExportFormats = ImmutableMap.builder().put((Object)"convert/to19139.xsl", (Object)"metadata-iso19139.xml").build();

    public ISO19139SchemaPlugin() {
        super(IDENTIFIER, allNamespaces);
    }

    public Set<AssociatedResource> getAssociatedResourcesUUIDs(Element metadata) {
        String XPATH_FOR_AGGRGATIONINFO = "*//gmd:aggregationInfo/*[gmd:aggregateDataSetIdentifier/*/gmd:code and gmd:associationType/gmd:DS_AssociationTypeCode/@codeListValue!='']";
        HashSet<AssociatedResource> listOfResources = new HashSet<AssociatedResource>();
        List sibs = null;
        try {
            sibs = Xml.selectNodes((Element)metadata, (String)XPATH_FOR_AGGRGATIONINFO, (List)allNamespaces.asList());
            for (Object o : sibs) {
                try {
                    if (!(o instanceof Element)) continue;
                    Element sib = (Element)o;
                    Element agId = (Element)sib.getChild("aggregateDataSetIdentifier", ISO19139Namespaces.GMD).getChildren().get(0);
                    String sibUuid = this.getChild(agId, "code", ISO19139Namespaces.GMD).getChildText("CharacterString", ISO19139Namespaces.GCO);
                    Element associationTypeEl = this.getChild(sib, "associationType", ISO19139Namespaces.GMD);
                    String associationType = this.getChild(associationTypeEl, "DS_AssociationTypeCode", ISO19139Namespaces.GMD).getAttributeValue("codeListValue");
                    Element initiativeTypeEl = this.getChild(sib, "initiativeType", ISO19139Namespaces.GMD);
                    String initiativeType = "";
                    if (initiativeTypeEl != null) {
                        initiativeType = this.getChild(initiativeTypeEl, "DS_InitiativeTypeCode", ISO19139Namespaces.GMD).getAttributeValue("codeListValue");
                    }
                    AssociatedResource resource = new AssociatedResource(sibUuid, initiativeType, associationType);
                    listOfResources.add(resource);
                }
                catch (Exception e) {
                    Log.error((String)"jeeves", (Object)"Error getting resources UUIDs", (Throwable)e);
                }
            }
        }
        catch (Exception e) {
            Log.error((String)"jeeves", (Object)"Error getting resources UUIDs", (Throwable)e);
        }
        return listOfResources;
    }

    private Element getChild(Element el, String name, Namespace namespace) {
        Element child = el.getChild(name, namespace);
        if (child == null) {
            return new Element(name, namespace);
        }
        return child;
    }

    public Set<String> getAssociatedParentUUIDs(Element metadata) {
        ElementFilter elementFilter = new ElementFilter("parentIdentifier", ISO19139Namespaces.GMD);
        return Xml.filterElementValues((Element)metadata, (ElementFilter)elementFilter, (String)"CharacterString", (Namespace)ISO19139Namespaces.GCO, null);
    }

    public Set<String> getAssociatedDatasetUUIDs(Element metadata) {
        return this.getAttributeUuidrefValues(metadata, "operatesOn", ISO19139Namespaces.SRV);
    }

    public Set<String> getAssociatedFeatureCatalogueUUIDs(Element metadata) {
        return this.getAttributeUuidrefValues(metadata, "featureCatalogueCitation", ISO19139Namespaces.GMD);
    }

    public Set<String> getAssociatedSourceUUIDs(Element metadata) {
        return this.getAttributeUuidrefValues(metadata, "source", ISO19139Namespaces.GMD);
    }

    private Set<String> getAttributeUuidrefValues(Element metadata, String tagName, Namespace namespace) {
        ElementFilter elementFilter = new ElementFilter(tagName, namespace);
        return Xml.filterElementValues((Element)metadata, (ElementFilter)elementFilter, null, null, (String)"uuidref");
    }

    public List<Element> getTranslationForElement(Element element, String languageIdentifier) {
        String path = ".//gmd:LocalisedCharacterString[@locale='#" + languageIdentifier + "']";
        try {
            XPath xpath = XPath.newInstance((String)path);
            List matches = xpath.selectNodes((Object)element);
            return matches;
        }
        catch (Exception e) {
            Log.debug((String)"geonetwork.schema-plugin", (Object)(this.getIdentifier() + ": getTranslationForElement failed on element " + Xml.getString((Element)element) + " using XPath '" + path + "updatedLocalizedTextElement exception " + e.getMessage()));
            return null;
        }
    }

    public void addTranslationToElement(Element element, String languageIdentifier, String value) {
        element.setAttribute("type", "gmd:PT_FreeText_PropertyType", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        Element langElem = new Element("LocalisedCharacterString", ISO19139Namespaces.GMD);
        langElem.setAttribute("locale", "#" + languageIdentifier);
        langElem.setText(value);
        Element textGroupElement = new Element("textGroup", ISO19139Namespaces.GMD);
        textGroupElement.addContent((Content)langElem);
        Element freeTextElement = element.getChild("PT_FreeText", ISO19139Namespaces.GMD);
        if (freeTextElement == null) {
            freeTextElement = new Element("PT_FreeText", ISO19139Namespaces.GMD);
            element.addContent((Content)freeTextElement);
        }
        freeTextElement.addContent((Content)textGroupElement);
    }

    public Element removeTranslationFromElement(Element element, List<String> langs) throws JDOMException {
        String mainLanguage = langs != null && langs.size() > 0 ? langs.get(0) : "#EN";
        List nodesWithStrings = Xml.selectNodes((Element)element, (String)"*//gmd:PT_FreeText", Arrays.asList(ISO19139Namespaces.GMD));
        for (Object e : nodesWithStrings) {
            List mainLangElement;
            Element mainCharacterString = ((Element)e.getParent()).getChild("CharacterString", ISO19139Namespaces.GCO);
            if (mainCharacterString == null) {
                mainCharacterString = new Element("CharacterString", ISO19139Namespaces.GCO);
                ((Element)e.getParent()).addContent(0, (Content)mainCharacterString);
            }
            if ((mainLangElement = Xml.selectNodes((Element)e, (String)("*//gmd:LocalisedCharacterString[@locale='" + mainLanguage + "']"), Arrays.asList(ISO19139Namespaces.GMD))).size() == 1) {
                String mainLangString = ((Element)mainLangElement.get(0)).getText();
                if (StringUtils.isNotEmpty((String)mainLangString)) {
                    mainCharacterString.setText(mainLangString);
                    continue;
                }
                if (mainCharacterString.getAttribute("nilReason", ISO19139Namespaces.GCO) != null) continue;
                ((Element)mainCharacterString.getParent()).setAttribute("nilReason", "missing", ISO19139Namespaces.GCO);
                continue;
            }
            if (!StringUtils.isEmpty((String)mainCharacterString.getText())) continue;
            ((Element)mainCharacterString.getParent()).setAttribute("nilReason", "missing", ISO19139Namespaces.GCO);
        }
        List translationNodes = Xml.selectNodes((Element)element, (String)"*//node()[@locale]");
        for (Element el : translationNodes) {
            if (langs.size() > 1 && langs.contains(el.getAttribute("locale").getValue())) continue;
            Element parent = (Element)el.getParent();
            parent.detach();
        }
        for (Element el : nodesWithStrings) {
            if (el.getChildren().size() != 0) continue;
            el.detach();
        }
        if (langs.size() > 1) {
            List elementList = Xml.selectNodes((Element)element, (String)".//*[gmd:PT_FreeText]", Arrays.asList(ISO19139Namespaces.GMD));
            for (Element el : elementList) {
                Element ptFreeText = el.getChild("PT_FreeText", ISO19139Namespaces.GMD);
                ArrayList<Element> orderedTextGroup = new ArrayList<Element>();
                for (String l : langs) {
                    List node = Xml.selectNodes((Element)ptFreeText, (String)("gmd:textGroup[*/@locale='" + l + "']"), Arrays.asList(ISO19139Namespaces.GMD));
                    if (node == null || node.size() != 1) continue;
                    orderedTextGroup.add((Element)((Element)node.get(0)).clone());
                }
                ptFreeText.removeContent();
                ptFreeText.addContent(orderedTextGroup);
            }
        }
        return element;
    }

    public String getBasicTypeCharacterStringName() {
        return "gco:CharacterString";
    }

    public Element createBasicTypeCharacterString() {
        return new Element("CharacterString", ISO19139Namespaces.GCO);
    }

    public Element addOperatesOn(Element serviceRecord, Map<String, String> layers, String serviceType, String baseUrl) {
        Element root = serviceRecord.getChild("identificationInfo", ISO19139Namespaces.GMD).getChild("SV_ServiceIdentification", ISO19139Namespaces.SRV);
        if (root != null) {
            Element couplingType = root.getChild("couplingType", ISO19139Namespaces.SRV);
            int coupledResourceIdx = root.indexOf((Content)couplingType);
            layers.keySet().forEach(uuid -> {
                String layerName = (String)layers.get(uuid);
                Element coupledResource = new Element("coupledResource", ISO19139Namespaces.SRV);
                coupledResource.setAttribute("nilReason", "synchronizedFromOGC", ISO19139Namespaces.GCO);
                Element scr = new Element("SV_CoupledResource", ISO19139Namespaces.SRV);
                Element operation = new Element("operationName", ISO19139Namespaces.SRV);
                Element operationValue = new Element("CharacterString", ISO19139Namespaces.GCO);
                if (serviceType.startsWith("WMS")) {
                    operationValue.setText("GetMap");
                } else if (serviceType.startsWith("WFS")) {
                    operationValue.setText("GetFeature");
                } else if (serviceType.startsWith("WCS")) {
                    operationValue.setText("GetCoverage");
                } else if (serviceType.startsWith("SOS")) {
                    operationValue.setText("GetObservation");
                }
                operation.addContent((Content)operationValue);
                Element id = new Element("identifier", ISO19139Namespaces.SRV);
                Element idValue = new Element("CharacterString", ISO19139Namespaces.GCO);
                idValue.setText(uuid);
                id.addContent((Content)idValue);
                Element scopedName = new Element("ScopedName", ISO19139Namespaces.GCO);
                scopedName.setText(layerName);
                scr.addContent((Content)operation);
                scr.addContent((Content)id);
                scr.addContent((Content)scopedName);
                coupledResource.addContent((Content)scr);
                if (coupledResourceIdx != -1) {
                    root.addContent(coupledResourceIdx, (Content)coupledResource);
                }
                Element op = new Element("operatesOn", ISO19139Namespaces.SRV);
                op.setAttribute("nilReason", "synchronizedFromOGC", ISO19139Namespaces.GCO);
                op.setAttribute("uuidref", uuid);
                String hRefLink = baseUrl + "api/records/" + uuid + "/formatters/xml";
                op.setAttribute("href", hRefLink, ISO19139Namespaces.XLINK);
                root.addContent((Content)op);
            });
        }
        return serviceRecord;
    }

    public List<ISOPlugin.Extent> getExtents(Element record) {
        ArrayList<ISOPlugin.Extent> extents = new ArrayList<ISOPlugin.Extent>();
        ElementFilter bboxFinder = new ElementFilter("EX_GeographicBoundingBox", ISO19139Namespaces.GMD);
        Iterator bboxes = record.getDescendants((Filter)bboxFinder);
        while (bboxes.hasNext()) {
            Element box = (Element)bboxes.next();
            try {
                extents.add(new ISOPlugin.Extent(Double.valueOf(box.getChild("westBoundLongitude", ISO19139Namespaces.GMD).getChild("Decimal", ISO19139Namespaces.GCO).getText()), Double.valueOf(box.getChild("eastBoundLongitude", ISO19139Namespaces.GMD).getChild("Decimal", ISO19139Namespaces.GCO).getText()), Double.valueOf(box.getChild("southBoundLatitude", ISO19139Namespaces.GMD).getChild("Decimal", ISO19139Namespaces.GCO).getText()), Double.valueOf(box.getChild("northBoundLatitude", ISO19139Namespaces.GMD).getChild("Decimal", ISO19139Namespaces.GCO).getText())));
            }
            catch (NullPointerException nullPointerException) {}
        }
        return extents;
    }

    public Map<String, Namespace> getCswTypeNames() {
        return allTypenames;
    }

    public Map<String, String> getExportFormats() {
        return allExportFormats;
    }

    public Element processElement(Element el, String attributeRef, String parsedAttributeName, String attributeValue) {
        boolean elementToProcess;
        if (Log.isDebugEnabled((String)"geonetwork.schema-plugin")) {
            Log.debug((String)"geonetwork.schema-plugin", (Object)String.format("Processing element %s, attribute %s with attributeValue %s.", el, attributeRef, attributeValue));
        }
        if ((elementToProcess = this.isElementToProcess(el)) && parsedAttributeName.equals("xlink:href")) {
            Element targetElement;
            boolean isEmptyLink = StringUtils.isEmpty((String)attributeValue);
            boolean isMultilingualElement = el.getName().equals("LocalisedCharacterString");
            if (isMultilingualElement && (targetElement = el.getParentElement().getParentElement().getParentElement().getChild("CharacterString", ISO19139Namespaces.GCO)) != null) {
                el = targetElement;
            }
            if (isEmptyLink) {
                el.setNamespace(ISO19139Namespaces.GCO).setName("CharacterString");
                el.removeAttribute("href", ISO19139Namespaces.XLINK);
                return el;
            }
            el.setNamespace(ISO19139Namespaces.GMX).setName("Anchor");
            el.setAttribute("href", "", ISO19139Namespaces.XLINK);
            return el;
        }
        if (elementToProcess && StringUtils.isNotEmpty((String)parsedAttributeName) && parsedAttributeName.startsWith(":")) {
            el.setAttribute(parsedAttributeName.substring(1), attributeValue);
            return el;
        }
        return super.processElement(el, attributeRef, parsedAttributeName, attributeValue);
    }

    protected boolean isElementToProcess(Element el) {
        if (el == null) {
            return false;
        }
        return this.elementsToProcess.contains(el.getQualifiedName());
    }

    public static List<String> getLanguages(Element md) {
        ArrayList<String> languages = new ArrayList<String>();
        try {
            List locales;
            String mainLanguage = ISO19139SchemaPlugin.getMainLanguage(md);
            if (mainLanguage.length() > 0) {
                languages.add(mainLanguage);
            }
            if ((locales = Xml.selectNodes((Element)md, (String)"gmd:locale/*/gmd:languageCode/*/@codeListValue", (List)allNamespaces.asList())) != null) {
                locales.stream().map(Attribute::getValue).filter(Objects::nonNull).filter(l -> !l.equalsIgnoreCase(mainLanguage)).forEach(l -> languages.add((String)l));
            }
        }
        catch (JDOMException jDOMException) {
            // empty catch block
        }
        return languages;
    }

    public <L, M> RawLinkPatternStreamer<L, M> createLinkStreamer(ILinkBuilder<L, M> linkbuilder) {
        RawLinkPatternStreamer patternStreamer = new RawLinkPatternStreamer(linkbuilder);
        patternStreamer.setNamespaces((List)allNamespaces.asList());
        patternStreamer.setRawTextXPath(".//*[name() = 'gco:CharacterString' or name() = 'gmd:URL']");
        return patternStreamer;
    }

    private static String getMainLanguage(Element md) throws JDOMException {
        Attribute mainLanguageAttribute = (Attribute)Xml.selectSingle((Element)md, (String)"gmd:language/*/@codeListValue", (List)allNamespaces.asList());
        if (mainLanguageAttribute != null && StringUtils.isNotEmpty((String)mainLanguageAttribute.getValue())) {
            return mainLanguageAttribute.getValue();
        }
        Element mainLanguageElem = (Element)Xml.selectSingle((Element)md, (String)"gmd:language/*", (List)allNamespaces.asList());
        if (mainLanguageElem != null && StringUtils.isNotEmpty((String)mainLanguageElem.getText())) {
            return mainLanguageElem.getText();
        }
        return "";
    }
}

