/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetLabeler;

public class RegExpAndReplaceOnPathLabeler
implements CrawlableDatasetLabeler {
    private String regExp;
    private Pattern pattern;
    private String replaceString;

    public RegExpAndReplaceOnPathLabeler(String regExp, String replaceString) {
        this.regExp = regExp;
        this.pattern = Pattern.compile(regExp);
        this.replaceString = replaceString;
    }

    @Override
    public Object getConfigObject() {
        return null;
    }

    public String getRegExp() {
        return this.regExp;
    }

    public String getReplaceString() {
        return this.replaceString;
    }

    @Override
    public String getLabel(CrawlableDataset dataset) {
        Matcher matcher = this.pattern.matcher(dataset.getPath());
        if (!matcher.find()) {
            return null;
        }
        StringBuffer startTime = new StringBuffer();
        matcher.appendReplacement(startTime, this.replaceString);
        startTime.delete(0, matcher.start());
        if (startTime.length() == 0) {
            return null;
        }
        return startTime.toString();
    }
}

