/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.guiapi.search;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import jeeves.server.ServiceConfig;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.guiapi.search.XsltResponseWriter;
import org.fao.geonet.kernel.search.LuceneSearcher;
import org.fao.geonet.kernel.search.SearchManager;
import org.fao.geonet.kernel.search.SearcherType;
import org.fao.geonet.services.util.SearchDefaults;
import org.fao.geonet.utils.Log;
import org.fao.geonet.utils.Xml;
import org.jdom.Content;
import org.jdom.Element;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import springfox.documentation.annotations.ApiIgnore;

@RequestMapping(value={"/{portal}/search"})
@Api(value="search", tags={"search"}, description="Search operations")
@Controller(value="search")
public class SearchApi {
    public static final String APPLICATION_RDF_XML = "application/rdf+xml";

    @ApiOperation(value="Get statistics about a field", notes="(experimental) This return facet info for the requested field and provide a list of values.", nickname="getRecords")
    @RequestMapping(produces={"text/html", "application/json", "application/xml", "application/rdf+xml"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    public void getFieldInfo(@ApiIgnore HttpServletRequest request, @ApiIgnore HttpServletResponse response, @ApiIgnore @RequestHeader(value="Accept", defaultValue="text/html") String accept, @ApiIgnore @RequestParam Map<String, String> allRequestParams) throws Exception {
        boolean isRdf = APPLICATION_RDF_XML.equals(accept);
        boolean isXml = "application/xml".equals(accept);
        boolean isJson = "application/json".equals(accept);
        if (allRequestParams.get("resultType") == null) {
            allRequestParams.put("resultType", "details");
        }
        allRequestParams.put("fast", isRdf ? "false" : "index");
        response.setHeader("Content-type", (isRdf || isXml || isJson ? accept : "text/html") + ";charset=utf-8");
        Element results = this.query(allRequestParams, request);
        if (isXml) {
            response.getWriter().write(Xml.getString((Element)results));
        } else if (isJson) {
            response.getWriter().write(Xml.getJSON((Element)results));
        } else {
            response.getWriter().write(new XsltResponseWriter("search").withJson("catalog/locales/en-core.json").withJson("catalog/locales/en-search.json").withXml(results).withXsl(isRdf ? "xslt/services/dcat/rdf.xsl" : "xslt/ui-search/search-nojs.xsl").asHtml());
        }
    }

    private Element query(Map<String, String> queryFields, HttpServletRequest request) {
        ConfigurableApplicationContext applicationContext = ApplicationContextHolder.get();
        SearchManager searchMan = (SearchManager)applicationContext.getBean(SearchManager.class);
        ServiceContext context = ApiUtils.createServiceContext(request);
        Element params = new Element("params");
        queryFields.forEach((k, v) -> params.addContent((Content)new Element(k).setText(v)));
        Element elData = SearchDefaults.getDefaultSearch((ServiceContext)context, (Element)params);
        LuceneSearcher searcher = null;
        Element model = new Element("search");
        model.addContent((Content)params);
        try {
            searcher = (LuceneSearcher)searchMan.newSearcher(SearcherType.LUCENE, "lucene.xsl");
            ServiceConfig config = new ServiceConfig();
            searcher.search(context, elData, config);
            model.addContent((Content)searcher.getSummary());
            if (queryFields.get("summaryOnly") == null) {
                model.addContent((Content)searcher.present(context, params, config));
            }
        }
        catch (Exception e) {
            Log.error((String)"geonetwork.api", (Object)("SeachApi - query: " + e.getMessage()), (Throwable)e);
        }
        return model;
    }
}

