/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.status;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.api.ApiUtils;
import org.fao.geonet.domain.StatusValue;
import org.fao.geonet.domain.StatusValueType;
import org.fao.geonet.repository.MetadataStatusRepository;
import org.fao.geonet.repository.StatusValueRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/status", "/{portal}/api/0.1/status"})
@Api(value="status", tags={"status"}, description="Workflow status operations")
@Controller(value="status")
public class StatusApi {
    @Autowired
    StatusValueRepository statusValueRepository;
    @Autowired
    MetadataStatusRepository metadataStatusRepository;

    @ApiOperation(value="Get status", notes="", nickname="getStatus")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<StatusValue> getStatus(HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        return this.statusValueRepository.findAll();
    }

    @ApiOperation(value="Get status by type", notes="", nickname="getStatusByType")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET}, path={"/{type}"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public List<StatusValue> getStatusByType(@ApiParam(value="Type", required=true) @PathVariable StatusValueType type, HttpServletRequest request) throws Exception {
        ServiceContext context = ApiUtils.createServiceContext(request);
        return this.statusValueRepository.findAllByType(type);
    }

    @ApiOperation(value="Delete all record history and status", notes="", nickname="deleteAllHistoryAndStatus")
    @RequestMapping(method={RequestMethod.DELETE})
    @PreAuthorize(value="hasRole('Administrator')")
    @ApiResponses(value={@ApiResponse(code=204, message="Status removed."), @ApiResponse(code=403, message="Operation not allowed. Only Administrators can access it.")})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAllHistoryAndStatus(HttpServletRequest request) throws Exception {
        this.metadataStatusRepository.deleteAll();
    }
}

