/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.records.formatters;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.vividsolutions.jts.util.Assert;
import groovy.util.slurpersupport.GPathResult;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import jeeves.server.context.ServiceContext;
import org.fao.geonet.ApplicationContextHolder;
import org.fao.geonet.api.records.formatters.ConfigFile;
import org.fao.geonet.api.records.formatters.SchemaLocalization;
import org.fao.geonet.api.records.formatters.groovy.CurrentLanguageHolder;
import org.fao.geonet.api.tools.i18n.LanguageUtils;
import org.fao.geonet.domain.IsoLanguage;
import org.fao.geonet.kernel.SchemaManager;
import org.fao.geonet.languages.IsoLanguagesMapper;
import org.fao.geonet.repository.IsoLanguageRepository;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class SchemaLocalizations {
    public static final String LANG_CODELIST_NS = "http://www.loc.gov/standards/iso639-2/";
    private final List<SchemaLocalization> schemaLocalizations;
    private final CurrentLanguageHolder languageHolder;
    private final IsoLanguageRepository languageRepo;

    public SchemaLocalizations(ApplicationContext context, CurrentLanguageHolder languageHolder, String schema, String extraSchemas) throws IOException, JDOMException {
        this.languageHolder = languageHolder;
        this.languageRepo = (IsoLanguageRepository)context.getBean(IsoLanguageRepository.class);
        ArrayList tmpLocalizations = Lists.newArrayList();
        SchemaManager schemaManager = (SchemaManager)context.getBean(SchemaManager.class);
        Map<String, SchemaLocalization> allLocalizations = this.getSchemaLocalizations(context, schemaManager);
        tmpLocalizations.add(allLocalizations.get(schema));
        this.addParentLocalizations(schemaManager, allLocalizations, tmpLocalizations, this.getConfigFile(schemaManager, schema).dependOn());
        this.addParentLocalizations(schemaManager, allLocalizations, tmpLocalizations, extraSchemas);
        this.schemaLocalizations = Collections.unmodifiableList(tmpLocalizations);
    }

    static Map<String, SchemaLocalization> loadSchemaLocalizations(ApplicationContext context, SchemaManager schemaManager) throws IOException, JDOMException {
        HashMap localization = Maps.newHashMap();
        Set allSchemas = schemaManager.getSchemas();
        for (String schema : allSchemas) {
            Map schemaInfo = schemaManager.getSchemaInfo(schema);
            localization.put(schema, new SchemaLocalization(context, schema, schemaInfo));
        }
        return localization;
    }

    public static SchemaLocalizations create(String schema) throws IOException, JDOMException {
        RequestAttributes obj = RequestContextHolder.getRequestAttributes();
        ServletRequestAttributes attributes = (ServletRequestAttributes)obj;
        HttpServletRequest request = attributes.getRequest();
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        ServiceContext serviceContext = ServiceContext.get();
        String lang3 = serviceContext != null ? serviceContext.getLanguage() : ((LanguageUtils)appContext.getBean(LanguageUtils.class)).getIso3langCode(request.getLocales());
        return SchemaLocalizations.create(schema, lang3);
    }

    public static SchemaLocalizations create(String schema, final String lang3) throws IOException, JDOMException {
        ConfigurableApplicationContext appContext = ApplicationContextHolder.get();
        final String lang2 = ((IsoLanguagesMapper)appContext.getBean(IsoLanguagesMapper.class)).iso639_2_to_iso639_1(lang3);
        CurrentLanguageHolder languageHolder = new CurrentLanguageHolder(){

            @Override
            public String getLang3() {
                return lang3;
            }

            @Override
            public String getLang2() {
                return lang2;
            }
        };
        return new SchemaLocalizations((ApplicationContext)appContext, languageHolder, schema, null);
    }

    private void addParentLocalizations(SchemaManager schemaManager, Map<String, SchemaLocalization> allLocalizations, ArrayList<SchemaLocalization> tmpLocalizations, String dependantSchema) throws IOException {
        if (dependantSchema == null) {
            return;
        }
        SchemaLocalization schemaLocalization = allLocalizations.get(dependantSchema);
        if (schemaLocalization != null) {
            tmpLocalizations.add(schemaLocalization);
        }
        ConfigFile parentConfig = this.getConfigFile(schemaManager, dependantSchema);
        this.addParentLocalizations(schemaManager, allLocalizations, tmpLocalizations, parentConfig.dependOn());
    }

    @VisibleForTesting
    protected ConfigFile getConfigFile(SchemaManager schemaManager, String schema) throws IOException {
        Path schemaDir = schemaManager.getSchemaDir(schema).resolve("formatter");
        return new ConfigFile(schemaDir, false, null);
    }

    @VisibleForTesting
    protected Map<String, SchemaLocalization> getSchemaLocalizations(ApplicationContext context, SchemaManager schemaManager) throws IOException, JDOMException {
        return SchemaLocalizations.loadSchemaLocalizations(context, schemaManager);
    }

    public String nodeLabel(GPathResult node) throws Exception {
        String parentNodeName = this.parentNodeName(node);
        return this.nodeLabel(node.name(), parentNodeName);
    }

    public String nodeLabel(String qualifiedNodeName, String qualifiedParentNodeName) throws Exception {
        return this.nodeTranslation(qualifiedNodeName, qualifiedParentNodeName, "label");
    }

    public String nodeDesc(GPathResult node) throws Exception {
        String parentNodeName = this.parentNodeName(node);
        return this.nodeDesc(node.name(), parentNodeName);
    }

    protected String parentNodeName(GPathResult node) {
        GPathResult parentNode = node.parent();
        String parentNodeName = null;
        if (parentNode != node) {
            parentNodeName = parentNode.name();
        }
        return parentNodeName;
    }

    public String nodeDesc(String qualifiedNodeName, String qualifiedParentNodeName) throws Exception {
        return this.nodeTranslation(qualifiedNodeName, qualifiedParentNodeName, "description");
    }

    public String nodeTranslation(String qualifiedNodeName, String qualifiedParentNodeName, String type) throws Exception {
        if (qualifiedParentNodeName == null) {
            qualifiedParentNodeName = "";
        }
        for (SchemaLocalization schemaLocalization : this.schemaLocalizations) {
            ImmutableCollection values;
            ImmutableTable<String, String, Element> labelIndex = schemaLocalization.getLabelIndex(this.languageHolder.getLang3());
            Element element = (Element)labelIndex.get((Object)qualifiedNodeName, (Object)qualifiedParentNodeName);
            if (element == null) {
                element = (Element)labelIndex.get((Object)qualifiedNodeName, (Object)"");
            }
            if (element == null && !(values = labelIndex.row((Object)qualifiedNodeName).values()).isEmpty()) {
                element = (Element)values.iterator().next();
            }
            if (element == null) continue;
            return element.getChildText(type);
        }
        return qualifiedNodeName;
    }

    public String codelistValueLabel(GPathResult node) throws Exception {
        return this.codelistValueLabel(node.getProperty("@codeList").toString(), node.getProperty("@codeListValue").toString());
    }

    public String codelistValueLabel(String codelist, String value) throws Exception {
        return this.codelistTranslation(codelist, value, "label");
    }

    public String codelistValueDesc(GPathResult node) throws Exception {
        return this.codelistValueDesc(node.getProperty("@codeList").toString(), node.getProperty("@codeListValue").toString());
    }

    public String codelistValueDesc(String codelist, String value) throws Exception {
        return this.codelistTranslation(codelist, value, "description");
    }

    public String codelistTranslation(String codelist, String context, String type) throws Exception {
        String codelistName = this.extractCodeListName(codelist);
        if (LANG_CODELIST_NS.equals(codelist) || "#LanguageCode".equals(codelist) || "LanguageCode".equals(codelistName)) {
            return this.translateLanguageCode(context);
        }
        for (SchemaLocalization schemaLocalization : this.schemaLocalizations) {
            Element codelistEl = (Element)schemaLocalization.getCodeListIndex(this.languageHolder.getLang3()).get((Object)codelistName, (Object)context);
            if (codelistEl == null) continue;
            return codelistEl.getChildText(type);
        }
        return context;
    }

    public String translateLanguageCode(String value) {
        List lang;
        if (value == null) {
            return null;
        }
        if (value.equals("deu")) {
            value = "ger";
        }
        if (!(lang = value.length() == 2 ? this.languageRepo.findAllByShortCode(value.toLowerCase()) : this.languageRepo.findAllByCode(value.toLowerCase())).isEmpty()) {
            IsoLanguage isoLanguage = (IsoLanguage)lang.get(0);
            String label = isoLanguage.getLabel(this.languageHolder.getLang3());
            if (label == null) {
                label = isoLanguage.getLabel("eng");
            }
            if (label == null) {
                label = value;
            }
            return label;
        }
        return value;
    }

    private String extractCodeListName(String codelist) {
        int indexOfPound = codelist.lastIndexOf(35);
        if (indexOfPound > -1) {
            codelist = codelist.substring(indexOfPound + 1);
        }
        return codelist;
    }

    public Collection<String> codelist(String codelistName) throws Exception {
        int prefix = codelistName.indexOf(58);
        if (prefix > -1) {
            codelistName = codelistName.substring(prefix + 1);
        }
        HashSet codelists = Sets.newHashSet();
        for (SchemaLocalization schemaLocalization : this.schemaLocalizations) {
            ImmutableTable<String, String, Element> codeListIndex = schemaLocalization.getCodeListIndex(this.languageHolder.getLang3());
            codelists.addAll(codeListIndex.row((Object)codelistName).keySet());
        }
        return codelists;
    }

    public String schemaString(String ... key) throws Exception {
        Assert.isTrue((key.length > 0 ? 1 : 0) != 0, (String)"There must be at least one key value");
        for (SchemaLocalization schemaLocalization : this.schemaLocalizations) {
            Element strings = schemaLocalization.getStrings(this.languageHolder.getLang3());
            for (int i = 0; i < key.length && (strings = strings.getChild(key[i])) != null; ++i) {
            }
            if (strings == null) continue;
            return strings.getTextNormalize();
        }
        return "[" + Joiner.on((char)',').join((Object[])key) + "]";
    }
}

