/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.api.identifiers;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import io.swagger.annotations.Authorization;
import java.io.Serializable;
import java.util.List;
import org.fao.geonet.api.exception.ResourceNotFoundException;
import org.fao.geonet.domain.MetadataIdentifierTemplate;
import org.fao.geonet.repository.MetadataIdentifierTemplateRepository;
import org.fao.geonet.repository.specification.MetadataIdentifierTemplateSpecs;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;

@RequestMapping(value={"/{portal}/api/identifiers", "/{portal}/api/0.1/identifiers"})
@Api(value="identifiers", tags={"identifiers"}, description="Identifiers operations")
@Controller(value="identifiers")
@PreAuthorize(value="hasRole('Editor')")
public class IdentifiersApi {
    private static final String API_PARAM_IDENTIFIER = "Identifier template identifier";
    private static final String API_PARAM_IDENTIFIER_TEMPLATE_DETAILS = "Identifier template details";
    public static final String MSG_NO_METADATA_IDENTIFIER_FOUND_WITH_ID = "No metadata identifier found with id '%d'.";
    @Autowired
    private MetadataIdentifierTemplateRepository metadataIdentifierTemplateRepository;

    @ApiOperation(value="Get identifier templates", notes="Identifier templates are used to create record UUIDs havind a particular structure. The template will be used when user creates a new record. The template identifier to use is defined in the administration > settings.", authorizations={@Authorization(value="basicAuth")}, nickname="getIdentifiers")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.OK)
    @ApiResponses(value={@ApiResponse(code=200, message="List of identifier templates."), @ApiResponse(code=403, message="Operation not allowed. Only Editor can access it.")})
    @PreAuthorize(value="hasRole('Editor') or hasRole('Reviewer') or hasRole('UserAdmin') or hasRole('Administrator')")
    @ResponseBody
    public List<MetadataIdentifierTemplate> getIdentifiers(@ApiParam(value="Only user defined ones", required=false) @RequestParam(required=false, defaultValue="false") boolean userDefinedOnly) throws Exception {
        if (userDefinedOnly) {
            return this.metadataIdentifierTemplateRepository.findAll(MetadataIdentifierTemplateSpecs.isSystemProvided((boolean)false));
        }
        return this.metadataIdentifierTemplateRepository.findAll();
    }

    @ApiOperation(value="Add an identifier template", notes="", authorizations={@Authorization(value="basicAuth")}, nickname="addIdentifier")
    @RequestMapping(produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.CREATED)
    @ApiResponses(value={@ApiResponse(code=201, message="Identifier template created."), @ApiResponse(code=403, message="Operation not allowed. Only Editor can access it.")})
    @PreAuthorize(value="hasRole('Editor') or hasRole('Reviewer') or hasRole('UserAdmin') or hasRole('Administrator')")
    @ResponseBody
    public ResponseEntity<Integer> addIdentifier(@ApiParam(value="Identifier template details") @RequestBody MetadataIdentifierTemplate metadataIdentifierTemplate) throws Exception {
        MetadataIdentifierTemplate existingId = (MetadataIdentifierTemplate)this.metadataIdentifierTemplateRepository.findOne((Serializable)Integer.valueOf(metadataIdentifierTemplate.getId()));
        if (existingId != null) {
            throw new IllegalArgumentException(String.format("A metadata identifier template with id '%d' already exist.", metadataIdentifierTemplate.getId()));
        }
        metadataIdentifierTemplate = (MetadataIdentifierTemplate)this.metadataIdentifierTemplateRepository.save((Object)metadataIdentifierTemplate);
        return new ResponseEntity((Object)metadataIdentifierTemplate.getId(), HttpStatus.CREATED);
    }

    @ApiOperation(value="Update an identifier template", notes="", authorizations={@Authorization(value="basicAuth")}, nickname="updateIdentifier")
    @RequestMapping(path={"/{identifier}"}, produces={"application/json"}, method={RequestMethod.PUT})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Identifier template updated."), @ApiResponse(code=404, message="Resource not found."), @ApiResponse(code=403, message="Operation not allowed. Only Editor can access it.")})
    @PreAuthorize(value="hasRole('Editor') or hasRole('Reviewer') or hasRole('UserAdmin') or hasRole('Administrator')")
    @ResponseBody
    public void updateIdentifier(@ApiParam(value="Identifier template identifier") @PathVariable Integer identifier, @ApiParam(value="Identifier template details") @RequestBody MetadataIdentifierTemplate metadataIdentifierTemplate) throws Exception {
        MetadataIdentifierTemplate existing = (MetadataIdentifierTemplate)this.metadataIdentifierTemplateRepository.findOne((Serializable)identifier);
        if (existing == null) {
            throw new ResourceNotFoundException(String.format(MSG_NO_METADATA_IDENTIFIER_FOUND_WITH_ID, identifier));
        }
        this.metadataIdentifierTemplateRepository.save((Object)metadataIdentifierTemplate);
    }

    @ApiOperation(value="Remove an identifier template", notes="", authorizations={@Authorization(value="basicAuth")}, nickname="deleteIdentifier")
    @RequestMapping(path={"/{identifier}"}, produces={"application/json"}, method={RequestMethod.DELETE})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    @ApiResponses(value={@ApiResponse(code=204, message="Template identifier removed."), @ApiResponse(code=404, message="Resource not found."), @ApiResponse(code=403, message="Operation not allowed. Only Editor can access it.")})
    @PreAuthorize(value="hasRole('Editor') or hasRole('Reviewer') or hasRole('UserAdmin') or hasRole('Administrator')")
    public void deleteIdentifier(@ApiParam(value="Identifier template identifier", required=true) @PathVariable int identifier) throws Exception {
        MetadataIdentifierTemplate existing = (MetadataIdentifierTemplate)this.metadataIdentifierTemplateRepository.findOne((Serializable)Integer.valueOf(identifier));
        if (existing == null) {
            throw new ResourceNotFoundException(String.format(MSG_NO_METADATA_IDENTIFIER_FOUND_WITH_ID, identifier));
        }
        this.metadataIdentifierTemplateRepository.delete((Serializable)Integer.valueOf(identifier));
    }
}

