/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.lite.gridcoverage2d;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import org.geotools.renderer.i18n.Errors;
import org.geotools.renderer.lite.gridcoverage2d.ColorMapUtilities;
import org.geotools.renderer.lite.gridcoverage2d.LinearColorMap;
import org.geotools.renderer.lite.gridcoverage2d.LinearColorMapElement;
import org.geotools.resources.i18n.Vocabulary;
import org.geotools.styling.ColorMapEntry;
import org.geotools.util.NumberRange;
import org.opengis.filter.expression.Expression;

public class SLDColorMapBuilder {
    public static final Color defaultColorForValuesToPreserve = new Color(0, 0, 0, 0);
    public static final Color defaultGapsColor = new Color(0, 0, 0, 0);
    private final List<LinearColorMapElement> colormapElements = new ArrayList<LinearColorMapElement>();
    private int linearColorMapType = -1;
    private Color gapsColor;
    private Color preservedValuesColor;
    private final List<Double> preservedValues = new ArrayList<Double>();
    private int colorsPerColorMapElement;
    private Color lastColorValue;
    private String name;
    private boolean extendedColors = false;
    private int numberColorMapEntries = -1;
    private int numberOfColorMapElements = -1;
    private LinearColorMap colorMap;

    public SLDColorMapBuilder() {
        this.name = "sld-colormap";
    }

    public SLDColorMapBuilder(String name) {
        ColorMapUtilities.ensureNonNull("name", name);
        this.name = name;
    }

    public void setGapsColor(Color defaultColor) {
        this.checkIfColorMapCreated();
        this.gapsColor = defaultColor;
    }

    private void checkIfColorMapCreated() throws IllegalStateException {
        if (this.colorMap != null) {
            throw new IllegalStateException(Errors.format(16));
        }
    }

    public SLDColorMapBuilder setLinearColorMapType(int colorMapType) {
        this.checkIfColorMapCreated();
        if (LinearColorMap.LinearColorMapType.validateColorMapTye(this.linearColorMapType)) {
            throw new IllegalStateException(Errors.format(16));
        }
        if (!LinearColorMap.LinearColorMapType.validateColorMapTye(colorMapType)) {
            throw new IllegalArgumentException(Errors.format(10, "colorMapType", Integer.toString(colorMapType)));
        }
        this.linearColorMapType = colorMapType;
        return this;
    }

    public int getLinearColorMapType() {
        return this.linearColorMapType;
    }

    public SLDColorMapBuilder addColorMapEntry(ColorMapEntry colorMapEntry) {
        Color newColorValue;
        block12: {
            double opacityValue;
            double q;
            String label;
            block11: {
                ColorMapUtilities.ensureNonNull("colorMapEntry", colorMapEntry);
                this.checkIfColorMapCreated();
                ColorMapUtilities.ensureNonNull("colorMapEntry", colorMapEntry);
                if (this.numberColorMapEntries == -1 || this.linearColorMapType == -1 || this.numberColorMapEntries < this.colormapElements.size() + 1) {
                    throw new IllegalStateException(Errors.format(16));
                }
                this.init();
                label = colorMapEntry.getLabel();
                label = label == null ? "ColorMapEntry" + this.colormapElements.size() : label;
                q = SLDColorMapBuilder.getQuantity(colorMapEntry);
                newColorValue = SLDColorMapBuilder.getColor(colorMapEntry);
                ColorMapUtilities.ensureNonNull("newColorValue", newColorValue);
                opacityValue = SLDColorMapBuilder.getOpacity(colorMapEntry);
                newColorValue = new Color(newColorValue.getRed(), newColorValue.getGreen(), newColorValue.getBlue(), (int)(opacityValue * 255.0 + 0.5));
                boolean firstEntry = this.colormapElements.isEmpty();
                if (!firstEntry) break block11;
                switch (this.linearColorMapType) {
                    case 1: {
                        this.colormapElements.add(LinearColorMapElement.create((CharSequence)label, newColorValue, (NumberRange<? extends Number>)NumberRange.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)q, (boolean)false), 0));
                        break block12;
                    }
                    case 3: {
                        this.colormapElements.add(LinearColorMapElement.create((CharSequence)label, newColorValue, q, 0));
                        break block12;
                    }
                    case 2: {
                        this.colormapElements.add(LinearColorMapElement.create((CharSequence)label, newColorValue, (NumberRange<? extends Number>)NumberRange.create((double)Double.NEGATIVE_INFINITY, (boolean)false, (double)q, (boolean)false), 0));
                        break block12;
                    }
                    default: {
                        throw new IllegalArgumentException(Errors.format(10, "ColorMapTransform.type", Double.toString(opacityValue), this.linearColorMapType));
                    }
                }
            }
            int newColorMapElementIndex = this.colormapElements.size();
            LinearColorMapElement previous = this.colormapElements.get(newColorMapElementIndex - 1);
            switch (this.linearColorMapType) {
                case 1: {
                    this.colormapElements.add(LinearColorMapElement.create((CharSequence)label, new Color[]{this.lastColorValue, newColorValue}, (NumberRange<? extends Number>)NumberRange.create((double)previous.getRange().getMaximum(), (boolean)true, (double)q, (boolean)false), (NumberRange<? extends Number>)NumberRange.create((int)((int)previous.getOutputMaximum()), (int)(this.colorsPerColorMapElement + (int)previous.getOutputMaximum()))));
                    break;
                }
                case 3: {
                    this.colormapElements.add(LinearColorMapElement.create((CharSequence)label, newColorValue, q, newColorMapElementIndex));
                    break;
                }
                case 2: {
                    this.colormapElements.add(LinearColorMapElement.create((CharSequence)label, newColorValue, (NumberRange<? extends Number>)NumberRange.create((double)previous.getRange().getMaximum(), (boolean)true, (double)q, (boolean)false), newColorMapElementIndex));
                    break;
                }
                default: {
                    throw new IllegalArgumentException(Errors.format(10, "ColorMapTransform.type", Double.toString(opacityValue), this.linearColorMapType));
                }
            }
        }
        this.lastColorValue = newColorValue;
        return this;
    }

    private void init() {
        if (this.numberOfColorMapElements != -1) {
            return;
        }
        if (this.numberColorMapEntries == 1 && this.linearColorMapType != 3) {
            throw new IllegalArgumentException(Errors.format(10, "colormap entries", "1"));
        }
        this.numberOfColorMapElements = this.numberColorMapEntries;
        if (this.linearColorMapType == 1) {
            double colorsToDistribute;
            double d = colorsToDistribute = !this.extendedColors && this.numberColorMapEntries < 256 ? 256.0 : 65536.0;
            if (this.gapsColor != null) {
                colorsToDistribute -= 1.0;
            }
            if (this.preservedValuesColor != null) {
                colorsToDistribute -= 1.0;
            }
            this.colorsPerColorMapElement = (int)(colorsToDistribute / (double)(this.numberOfColorMapElements - 1));
            ++this.numberOfColorMapElements;
        } else {
            this.colorsPerColorMapElement = 1;
        }
    }

    public double[] getValuesToPreserve() {
        if (this.preservedValues.size() == 0) {
            return new double[0];
        }
        double[] retVal = new double[this.preservedValues.size()];
        int i = 0;
        for (Double value : this.preservedValues) {
            retVal[i++] = value;
        }
        return retVal;
    }

    public SLDColorMapBuilder addValueToPreserve(double value) {
        this.checkIfColorMapCreated();
        assert (this.preservedValues != null);
        this.preservedValues.add(value);
        return this;
    }

    public SLDColorMapBuilder setColorForValuesToPreserve(Color color) {
        ColorMapUtilities.ensureNonNull("color", color);
        this.checkIfColorMapCreated();
        this.preservedValuesColor = color;
        return this;
    }

    public Color getColorForValuesToPreserve() {
        return this.preservedValuesColor;
    }

    private static Color getColor(ColorMapEntry entry) throws NumberFormatException {
        ColorMapUtilities.ensureNonNull("ColorMapEntry", entry);
        Expression color = entry.getColor();
        ColorMapUtilities.ensureNonNull("color", color);
        String colorString = (String)color.evaluate(null, String.class);
        ColorMapUtilities.ensureNonNull("colorString", colorString);
        return Color.decode(colorString);
    }

    private static double getOpacity(ColorMapEntry entry) throws IllegalArgumentException, MissingResourceException {
        ColorMapUtilities.ensureNonNull("ColorMapEntry", entry);
        ColorMapUtilities.ensureNonNull("entry", entry);
        Expression opacity = entry.getOpacity();
        Double opacityValue = null;
        if (opacity == null) {
            return 1.0;
        }
        opacityValue = (Double)opacity.evaluate(null, Double.class);
        if (opacityValue - 1.0 > 0.0 || opacityValue < 0.0) {
            throw new IllegalArgumentException(Errors.format(10, "Opacity", opacityValue));
        }
        return opacityValue;
    }

    private static double getQuantity(ColorMapEntry entry) {
        ColorMapUtilities.ensureNonNull("ColorMapEntry", entry);
        Expression quantity = entry.getQuantity();
        ColorMapUtilities.ensureNonNull("quantity", quantity);
        Double quantityString = (Double)quantity.evaluate(null, Double.class);
        ColorMapUtilities.ensureNonNull("quantityString", quantityString);
        double q = quantityString;
        return q;
    }

    public boolean getExtendedColors() {
        return this.extendedColors;
    }

    public SLDColorMapBuilder setExtendedColors(boolean extendedColors) {
        if (this.numberColorMapEntries != -1) {
            throw new IllegalStateException(Errors.format(16));
        }
        this.checkIfColorMapCreated();
        this.extendedColors = extendedColors;
        return this;
    }

    public int getNumberColorMapEntries() {
        return this.numberColorMapEntries;
    }

    public SLDColorMapBuilder setNumberColorMapEntries(int numberColorMapEntries) {
        this.checkIfColorMapCreated();
        if (this.numberColorMapEntries != -1) {
            throw new IllegalStateException(Errors.format(16));
        }
        if (numberColorMapEntries <= 0 || numberColorMapEntries > (this.extendedColors ? 65536 : 256)) {
            throw new IllegalArgumentException(Errors.format(10, "numberColorMapEntries", Integer.toString(numberColorMapEntries)));
        }
        this.numberColorMapEntries = numberColorMapEntries;
        return this;
    }

    public int getNumberOfColorMapElements() {
        return this.numberOfColorMapElements;
    }

    public LinearColorMap buildLinearColorMap() {
        if (this.numberColorMapEntries == -1) {
            throw new IllegalStateException(Errors.format(16));
        }
        if (this.colorMap != null) {
            return this.colorMap;
        }
        LinearColorMapElement last = this.colormapElements.get(this.colormapElements.size() - 1);
        if (this.linearColorMapType == 1) {
            LinearColorMapElement previous = last;
            last = LinearColorMapElement.create((CharSequence)("ColorMapEntry" + this.colormapElements.size()), this.lastColorValue, (NumberRange<? extends Number>)NumberRange.create((double)previous.getRange().getMaximum(), (boolean)true, (double)Double.POSITIVE_INFINITY, (boolean)false), (int)previous.getOutputMaximum());
            this.colormapElements.add(last);
        }
        LinearColorMapElement[] preservedValuesElement = new LinearColorMapElement[this.preservedValues.size()];
        int value = (int)last.getOutputMaximum() + 1;
        for (int i = 0; i < preservedValuesElement.length; ++i) {
            preservedValuesElement[i] = LinearColorMapElement.create((CharSequence)(Vocabulary.format((int)147) + Integer.toString(i + 1)), this.preservedValuesColor, (NumberRange<? extends Number>)NumberRange.create((double)this.preservedValues.get(i), (double)this.preservedValues.get(i)), value);
        }
        this.colorMap = new LinearColorMap(this.name, this.colormapElements.toArray(new LinearColorMapElement[this.colormapElements.size()]), preservedValuesElement, this.gapsColor);
        return this.colorMap;
    }
}

