/*
 * Decompiled with CFR 0.152.
 */
package bak.pcj.adapter;

import bak.pcj.Adapter;
import bak.pcj.BooleanCollection;
import bak.pcj.adapter.CollectionToBooleanCollectionAdapter;
import bak.pcj.adapter.SetToBooleanSetAdapter;
import bak.pcj.map.AbstractBooleanKeyBooleanMap;
import bak.pcj.map.BooleanKeyBooleanMap;
import bak.pcj.map.BooleanKeyBooleanMapIterator;
import bak.pcj.map.MapDefaults;
import bak.pcj.set.BooleanSet;
import bak.pcj.util.Exceptions;
import java.util.Iterator;
import java.util.Map;

public class MapToBooleanKeyBooleanMapAdapter
extends AbstractBooleanKeyBooleanMap
implements BooleanKeyBooleanMap {
    protected Map map;
    protected Boolean lastValue;

    public MapToBooleanKeyBooleanMapAdapter(Map map) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
    }

    public MapToBooleanKeyBooleanMapAdapter(Map map, boolean validate) {
        if (map == null) {
            Exceptions.nullArgument("map");
        }
        this.map = map;
        this.lastValue = null;
        if (validate) {
            this.evalidate();
        }
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(boolean key) {
        this.lastValue = (Boolean)this.map.get(new Boolean(key));
        return this.lastValue != null;
    }

    public boolean containsValue(boolean value) {
        return this.map.containsValue(new Boolean(value));
    }

    public BooleanKeyBooleanMapIterator entries() {
        return new BooleanKeyBooleanMapIterator(){
            Iterator i;
            Map.Entry lastEntry;
            {
                this.i = MapToBooleanKeyBooleanMapAdapter.this.map.entrySet().iterator();
                this.lastEntry = null;
            }

            public boolean hasNext() {
                return this.i.hasNext();
            }

            public void next() {
                this.lastEntry = (Map.Entry)this.i.next();
            }

            public boolean getKey() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Boolean)this.lastEntry.getKey();
            }

            public boolean getValue() {
                if (this.lastEntry == null) {
                    Exceptions.noElementToGet();
                }
                return (Boolean)this.lastEntry.getValue();
            }

            public void remove() {
                this.i.remove();
                this.lastEntry = null;
            }
        };
    }

    public boolean get(boolean key) {
        Boolean value = (Boolean)this.map.get(new Boolean(key));
        return value == null ? MapDefaults.defaultBoolean() : value;
    }

    public BooleanSet keySet() {
        return new SetToBooleanSetAdapter(this.map.keySet());
    }

    public boolean lget() {
        if (this.lastValue == null) {
            Exceptions.noLastElement();
        }
        return this.lastValue;
    }

    public boolean put(boolean key, boolean value) {
        Boolean oldValue = this.map.put(new Boolean(key), new Boolean(value));
        return oldValue == null ? MapDefaults.defaultBoolean() : oldValue;
    }

    public boolean remove(boolean key) {
        Boolean value = (Boolean)this.map.remove(new Boolean(key));
        return value == null ? MapDefaults.defaultBoolean() : value;
    }

    public int size() {
        return this.map.size();
    }

    public BooleanCollection values() {
        return new CollectionToBooleanCollectionAdapter(this.map.values());
    }

    public boolean tget(boolean key) {
        Boolean value = (Boolean)this.map.get(new Boolean(key));
        if (value == null) {
            Exceptions.noSuchMapping(String.valueOf(key));
        }
        return value;
    }

    public boolean validate() {
        return Adapter.isBooleanKeyBooleanAdaptable(this.map);
    }

    public void evalidate() {
        if (!this.validate()) {
            Exceptions.cannotAdapt("map");
        }
    }
}

