/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.Locale;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.camel.CamelContext;
import org.apache.camel.Consumer;
import org.apache.camel.spi.ScheduledPollConsumerScheduler;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultScheduledPollConsumerScheduler
extends ServiceSupport
implements ScheduledPollConsumerScheduler {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultScheduledPollConsumerScheduler.class);
    private CamelContext camelContext;
    private Consumer consumer;
    private ScheduledExecutorService scheduledExecutorService;
    private boolean shutdownExecutor;
    private volatile ScheduledFuture<?> future;
    private Runnable task;
    private long initialDelay = 1000L;
    private long delay = 500L;
    private TimeUnit timeUnit = TimeUnit.MILLISECONDS;
    private boolean useFixedDelay = true;

    @Override
    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void setCamelContext(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public long getInitialDelay() {
        return this.initialDelay;
    }

    public void setInitialDelay(long initialDelay) {
        this.initialDelay = initialDelay;
    }

    public long getDelay() {
        return this.delay;
    }

    public void setDelay(long delay) {
        this.delay = delay;
    }

    public TimeUnit getTimeUnit() {
        return this.timeUnit;
    }

    public void setTimeUnit(TimeUnit timeUnit) {
        this.timeUnit = timeUnit;
    }

    public boolean isUseFixedDelay() {
        return this.useFixedDelay;
    }

    public void setUseFixedDelay(boolean useFixedDelay) {
        this.useFixedDelay = useFixedDelay;
    }

    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    public void setScheduledExecutorService(ScheduledExecutorService scheduledExecutorService) {
        this.scheduledExecutorService = scheduledExecutorService;
    }

    @Override
    public void onInit(Consumer consumer) {
        this.consumer = consumer;
    }

    @Override
    public void scheduleTask(Runnable task) {
        this.task = task;
    }

    @Override
    public void unscheduleTask() {
        if (this.future != null) {
            this.future.cancel(false);
        }
    }

    @Override
    public void startScheduler() {
        if (this.future == null) {
            if (this.isUseFixedDelay()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduling poll (fixed delay) with initialDelay: {}, delay: {} ({}) for: {}", new Object[]{this.getInitialDelay(), this.getDelay(), this.getTimeUnit().name().toLowerCase(Locale.ENGLISH), this.consumer.getEndpoint()});
                }
                this.future = this.scheduledExecutorService.scheduleWithFixedDelay(this.task, this.getInitialDelay(), this.getDelay(), this.getTimeUnit());
            } else {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Scheduling poll (fixed rate) with initialDelay: {}, delay: {} ({}) for: {}", new Object[]{this.getInitialDelay(), this.getDelay(), this.getTimeUnit().name().toLowerCase(Locale.ENGLISH), this.consumer.getEndpoint()});
                }
                this.future = this.scheduledExecutorService.scheduleAtFixedRate(this.task, this.getInitialDelay(), this.getDelay(), this.getTimeUnit());
            }
        }
    }

    @Override
    public boolean isSchedulerStarted() {
        return this.future != null;
    }

    @Override
    protected void doStart() throws Exception {
        ObjectHelper.notNull(this.consumer, "Consumer", this);
        ObjectHelper.notNull(this.camelContext, "CamelContext", this);
        ObjectHelper.notNull(this.task, "Task", this);
        if (this.scheduledExecutorService == null) {
            this.scheduledExecutorService = this.getCamelContext().getExecutorServiceManager().newSingleThreadScheduledExecutor(this.consumer, this.consumer.getEndpoint().getEndpointUri());
            this.shutdownExecutor = true;
        }
    }

    @Override
    protected void doStop() throws Exception {
        if (this.future != null) {
            LOG.debug("This consumer is stopping, so cancelling scheduled task: " + this.future);
            this.future.cancel(true);
            this.future = null;
        }
        if (this.shutdownExecutor && this.scheduledExecutorService != null) {
            this.getCamelContext().getExecutorServiceManager().shutdownNow(this.scheduledExecutorService);
            this.scheduledExecutorService = null;
            this.future = null;
        }
    }
}

