/*
 * Decompiled with CFR 0.152.
 */
package org.fao.geonet.kernel.harvest.harvester;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import org.fao.geonet.domain.Pair;
import org.fao.geonet.kernel.schema.MetadataSchema;
import org.fao.geonet.utils.Xml;
import org.jdom.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HarvesterUtil {
    private static Logger LOGGER = LoggerFactory.getLogger((String)"geonetwork.harvester");

    public static Pair<String, Map<String, Object>> parseXSLFilter(String filter) {
        String processName = filter;
        HashMap<String, String> processParams = new HashMap<String, String>();
        if (filter.contains("?")) {
            String[] filterInfo = filter.split("\\?");
            processName = filterInfo[0];
            LOGGER.debug("      - XSL Filter name:{}", (Object)processName);
            if (filterInfo[1] != null) {
                String[] filterKVP;
                for (String kvp : filterKVP = filterInfo[1].split("&")) {
                    String[] param = kvp.split("=");
                    if (param.length == 2) {
                        LOGGER.debug("        with param:{} = {}", (Object)param[0], (Object)param[1]);
                        processParams.put(param[0], param[1]);
                        continue;
                    }
                    LOGGER.debug("        no value for param: {}", (Object)param[0]);
                }
            }
        }
        return Pair.read((Object)processName, processParams);
    }

    public static Element processMetadata(MetadataSchema metadataSchema, Element md, String processName, Map<String, Object> processParams) {
        Path filePath = metadataSchema.getSchemaDir().resolve("process").resolve(processName + ".xsl");
        if (!Files.exists(filePath, new LinkOption[0])) {
            LOGGER.info("     processing instruction not found for {} schema. metadata not filtered.", (Object)metadataSchema.getName());
        } else {
            try {
                Element processedMetadata = Xml.transform((Element)md, (Path)filePath, processParams);
                LOGGER.debug("     metadata filtered.");
                md = processedMetadata;
            }
            catch (Exception e) {
                LOGGER.warn("     processing error ({}): {}", (Object)processName, (Object)e.getMessage());
            }
        }
        return md;
    }
}

