/*
 * Decompiled with CFR 0.152.
 */
package ro.isdc.wro.model.resource.support;

import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ro.isdc.wro.util.provider.ProviderFinder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractConfigurableStrategySupport<S, P> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractConfigurableStrategySupport.class);
    private ProviderFinder<P> providerFinder;
    private Map<String, S> map;
    private Properties properties;

    protected S getStrategyForAlias(String alias) {
        return this.getStrategyMap().get(alias);
    }

    protected final String getConfiguredValue() {
        return this.getProperties().getProperty(this.getStrategyKey());
    }

    public final Set<String> getAvailableAliases() {
        return this.getStrategyMap().keySet();
    }

    public final Collection<S> getAvailableStrategies() {
        return this.getStrategyMap().values();
    }

    private final Map<String, S> newStrategyMap() {
        TreeMap<String, S> map = new TreeMap<String, S>();
        List<P> providers = this.getProviderFinder().find();
        LOG.debug("providers: {}", providers);
        for (P provider : providers) {
            try {
                map.putAll(this.getStrategies(provider));
            }
            catch (Exception e) {
                LOG.warn("Could not load strategies for provider: {}, because of: {}. It will be skipped.", provider, (Object)e.getMessage());
            }
        }
        this.overrideDefaultStrategyMap(map);
        return map;
    }

    protected void overrideDefaultStrategyMap(Map<String, S> map) {
    }

    protected final void copyAll(Map<String, S> source, Map<String, S> target) {
        Validate.notNull(source);
        Validate.notNull(target);
        for (Map.Entry<String, S> entry : source.entrySet()) {
            target.put(entry.getKey(), entry.getValue());
        }
    }

    private Map<String, S> getStrategyMap() {
        if (this.map == null) {
            this.map = this.newStrategyMap();
        }
        return this.map;
    }

    private Properties getProperties() {
        if (this.properties == null) {
            this.properties = this.newProperties();
        }
        return this.properties;
    }

    protected Properties newProperties() {
        return new Properties();
    }

    public final void setProperties(Properties props) {
        Validate.notNull((Object)props);
        this.properties = props;
    }

    protected ProviderFinder<P> getProviderFinder() {
        if (this.providerFinder == null) {
            this.providerFinder = ProviderFinder.of(this.getProviderClass());
        }
        return this.providerFinder;
    }

    protected Class<P> getProviderClass() {
        Type type = this.getClass().getGenericSuperclass();
        return (Class)((ParameterizedType)type).getActualTypeArguments()[1];
    }

    protected abstract Map<String, S> getStrategies(P var1);

    protected abstract String getStrategyKey();
}

